SYSTEM(Run=1) ! best to "Step" thru script the first time
MSG(T='This script will fit random observed data to|y=p₁+p₂x+p₃x²|OK will repeat this|More in FIT.hic')
DO
    xmc(10,3) = 0                            ! yCalculated (and sets the dimensions of xmc)
    xmc($,1) = 10*$ - RAN(10, 9)             ! x"Observed"
    xmc($,2) = RAN(50,45)                    ! y"Observed" = random(50 +- 40)
    p(3,5) = 0                               ! pStart/Result, deltap, correlations(numberof parameters)

.   get yCalculated = xmc($,3) (column 3 of xmc: initial guess with START parameters)
    XEQ("xmc($,3)=p(1,1)+(p(2,1)+p(3,1)*xmc($,1))*xmc($,1)")

.   prepare the graph:
    DLG(TI='FIT in a nutshell: y=p₁+p₂x+p₃x²', rows=2,cols=2, AX=4, TI='dots=observed, dotted=initial guess, solid=final result')

.   plot observations (blue dots) and initial guess (red, dotted):
    LINE(AX=4, OneWayX=1, Col=1,XV=xmc, Col=2,YV=xmc,S='⚫', D=-9,   Col=3,YV=xmc,W=3,S=' ', Broken=1.2,  D=900)

.   fit polynom to observations:
    iterations = FIT(Residual=res, Theory="xmc($,3)=p(1,1)+(p(2,1)+p(3,1)*xmc($,1))*xmc($,1)", Parms=p, XMY=xmc)

.   plot the fit result (red):
    LINE(AXis=4, OneWayX=1,   Column=1,XVec=xmc,    Col=3,YVec=xmc,W=3,S=' ',  Draw=900)

.   ! show result numerically:
    DLG(TI=res, L=0, W=1/2, Array=p, TI='i,p fitted,+-delta p,correl 1,correl 2,correl 3,')
ENDDO
